dn = 0.05;            % dimensionless grid size in n-direction (-)
dt = 0.8 * (dn^2)/2;  % dimensionless time step (-)
tmax = 0.1;           % dimensionless simulation time (-)

t = 0:dt:tmax; % vector of dimensionless time (-)
n = -1:dn:1;   % vector of dimensionless n-coordinates (-)

v = zeros(size(n)); % initial condition for dimensionless velocity (-)

for i = 1:numel(t) % loop in time for repeated application of Equation Box 2-6

    v(2:end-1) = v(2:end-1) + (2 + (v(1:end-2) - 2*v(2:end-1) + v(3:end)) / dn^2) * dt;
 % v(1) and v(end) always remain at zero here
 % to implement the no-slip boundary condition

end

figure
plot(v,n)
xlabel('v/v_{max} (-)')
ylabel('n/B (-)')
title(['t/T = ',num2str(tmax)])

